package net.sf.amateras.air.views;

import net.sf.amateras.air.as.ActionScriptConfiguration;
import net.sf.amateras.air.as.ActionScriptPartitionScanner;
import net.sf.amateras.air.mxml.VisualMXMLEditor;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

/**
 * 
 * @author Naoki Takezoe
 * @deprecated
 */
public class ActionScriptView extends ViewPart implements IPartListener {
	
	private VisualMXMLEditor currentEditor;
//	private Text text;
	private SourceViewer viewer;
	
	public void createPartControl(Composite parent) {
		CompositeRuler ruler = new CompositeRuler();
		ruler.addDecorator(0,new LineNumberRulerColumn());
		
		viewer = new SourceViewer(parent, ruler, SWT.BORDER|SWT.V_SCROLL|SWT.H_SCROLL);
		viewer.configure(new ActionScriptConfiguration());
		
		Document document = new Document();
		IDocumentPartitioner partitioner = new FastPartitioner(
		        new ActionScriptPartitionScanner(),
		        new String[] {
		        	ActionScriptPartitionScanner.AS_COMMENT,
		        	ActionScriptPartitionScanner.AS_STRING
		        });
		partitioner.connect(document);
		document.setDocumentPartitioner(partitioner);
		
		viewer.setDocument(document);
		viewer.getTextWidget().setLayoutData(new GridData(GridData.FILL_BOTH));
		viewer.getTextWidget().addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent evt) {
				if(currentEditor!=null){
					CommandStack stack = (CommandStack) currentEditor.getAdapter(CommandStack.class);
					stack.execute(new Command(){
//						private String previous = currentEditor.getRootModel().getScript();
						public void execute() {
//							currentEditor.getRootModel().setScript(viewer.getDocument().get());
						}
						public void undo() {
//							currentEditor.getRootModel().setScript(previous);
//							viewer.getDocument().set(previous);
						}
					});
				}
			}
		});
		
		IWorkbenchPage page = getSite().getPage();
		page.addPartListener(this);
		editorChanged();
	}

	public void dispose() {
		getSite().getPage().removePartListener(this);
		super.dispose();
	}

	public void setFocus() {
		viewer.getTextWidget().setFocus();
	}
	
	private void disableEditor(){
		currentEditor = null;
		viewer.getDocument().set("");
		viewer.getTextWidget().setEnabled(false);
	}
	
	private void editorChanged(){
		IWorkbenchPage page = getSite().getPage();
		if(page==null){
			disableEditor();
			return;
		}
		IEditorPart editor = page.getActiveEditor();
		if(editor==null){
			disableEditor();
			return;
		}
		if(editor.getEditorInput().getName().endsWith(".mxml")){
			if(editor instanceof VisualMXMLEditor){
				if(editor != currentEditor){
					VisualMXMLEditor visualEditor = (VisualMXMLEditor) editor;
					currentEditor = null;
//					viewer.getDocument().set(visualEditor.getRootModel().getScript());
					viewer.getTextWidget().setEnabled(true);
					currentEditor = visualEditor;
				}
				return;
			}
		}
		disableEditor();
	}
	
	/////////////////////////////////////////////////////////////
	// IPartListener methods
	/////////////////////////////////////////////////////////////
	public void partActivated(IWorkbenchPart part) {
		editorChanged();
	}

	public void partBroughtToTop(IWorkbenchPart part) {
		editorChanged();
	}

	public void partClosed(IWorkbenchPart part) {
	}

	public void partDeactivated(IWorkbenchPart part) {
	}

	public void partOpened(IWorkbenchPart part) {
		editorChanged();
	}

}
