package net.sf.amateras.air.util;

import java.lang.reflect.Field;

/**
 * 
 * @author Naoki Takezoe
 */
public class ReflectionUtil {
	
	public static Object getField(Object target, String fieldName){
		Class clazz = target.getClass();
		
		while(clazz != null){
			try {
				Field field = clazz.getDeclaredField(fieldName);
				field.setAccessible(true);
				
				return field.get(target);
				
			} catch(NoSuchFieldException ex){
			} catch(IllegalAccessException ex){
			}
			clazz = clazz.getSuperclass();
		}
		return null;
	}
	
	/**
	 * Returns the getter method name from the property name.
	 * 
	 * @param propertyName the property name
	 * @param isBool
	 * <ul>
	 *   <li>true  - returns isXxxx</li>
	 *   <li>false - returns getXxxx</li>
	 * </ul>
	 * @return the getter method name
	 */
	public static String getGetterName(String propertyName, boolean isBool){
		if(isBool){
			return "is" + propertyName.substring(0, 1).toUpperCase() + 
				propertyName.substring(1);
		} else {
			return "get" + propertyName.substring(0, 1).toUpperCase() + 
				propertyName.substring(1);
		}
	}
	
	/**
	 * Returns the setter method name from the property name.
	 * 
	 * @param propertyName the propery name
	 * @return the setter method name
	 */
	public static String getSetterName(String propertyName){
		return "set" + propertyName.substring(0, 1).toUpperCase() + 
			propertyName.substring(1);
	}
}
