package net.sf.amateras.air.util;

import java.util.HashMap;
import java.util.Map;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.models.AbstractComponentModel;
import net.sf.amateras.air.mxml.models.ButtonModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

/**
 * 
 * @author Hideko Ogawa
 *
 */
public class FontManager {

	private Map<FontData, Font> fonts = new HashMap<FontData, Font>();

	public Font getFont(String name, int height, int style) {
		return getFont(new FontData(name, height, style));
	}

	public Font getFont(FontData fontData) {
		Font font = fonts.get(fontData);
		if (font == null) {
			font = new Font(null, fontData);
			fonts.put(fontData, font);
		}
		return font;
	}

	/**
	 * Font is set to Figure. 
	 * Font information is acquired from FONT_FAMILY,FONT_SIZE,FONT_STYLE,FONT_WEIGHT of Model. 
	 * @param model
	 * @param figure
	 */
	public void setFont(AbstractComponentModel model, IFigure figure) {
		// font
		String fontFamily = model.getAttributeToString(ButtonModel.FONT_FAMILY);
		int fontSize = 10;
		if (model.getAttribute(ButtonModel.FONT_SIZE) != null) {
			fontSize = model.getAttributeToNumber(ButtonModel.FONT_SIZE);
			int mattingSize = AIRPlugin.getDefault().getPreferenceStore().getInt(
					AIRPlugin.PREF_FONT_MATTING_SIZE);
			if (mattingSize != 0 && (fontSize + mattingSize) > 0) {
				fontSize = fontSize + mattingSize;
			}

		}
		String fontStyle = model.getAttributeToString(ButtonModel.FONT_STYLE);
		String fontWeight = model.getAttributeToString(ButtonModel.FONT_WEIGHT);

		int style = SWT.NORMAL;
		if (fontStyle != null && fontStyle.equals("italic")) {
			style = SWT.ITALIC;
		} else if (fontWeight != null && fontWeight.equals("bold")) {
			style = SWT.BOLD;
		}

		if (fontFamily == null) {
			fontFamily = "Verdana";
		}

		Font font = AIRPlugin.getDefault().getFontManager().getFont(fontFamily, fontSize, style);
		if (font != figure.getFont()) {
			figure.setFont(font);
		}
	}

	public void dispose() {
		for (Font font : fonts.values()) {
			font.dispose();
		}
	}
}
