package net.sf.amateras.air.propertyPages;

import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.AirBuilderManager;
import net.sf.amateras.air.builder.CompileProperty;

import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/**
 * The property page for the SourceFolder CompileProperty.
 * 
 * @author ogawahideko
 */
public class BuildPropertyPage extends PropertyPage implements IWorkbenchPropertyPage {

	private TableViewer viewer;
	private List<CompileProperty> compiles = null;

	private IProject getProject() {
		IAdaptable adaptable = getElement();
		if (adaptable instanceof IProject) {
			return (IProject) adaptable;
		}
		return (IProject) adaptable.getAdapter(IProject.class);
	}

	private ScopedPreferenceStore getScopedPreferenceStore() {
		return new ScopedPreferenceStore(new ProjectScope(getProject()), AIRPlugin.PLUGIN_ID);
	}

	@Override
	protected Control createContents(Composite parent) {
		ScopedPreferenceStore store = getScopedPreferenceStore();
		setPreferenceStore(store);
		compiles = CompileProperty.load(store);

		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		viewer = new TableViewer(composite);
		viewer.getControl().setLayoutData(new GridData(GridData.FILL_BOTH));
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setLabelProvider(new ITableLabelProvider() {
			public Image getColumnImage(Object element, int column) {
				return AIRPlugin.getDefault().getImageRegistry().get("SOURCE_FOLDER");
			}

			public String getColumnText(Object element, int column) {
				return element.toString();
			}

			public void addListener(ILabelProviderListener listener) {
			}

			public void dispose() {
			}

			public boolean isLabelProperty(Object element, String property) {
				return false;
			}

			public void removeListener(ILabelProviderListener listener) {
			}
		});
		try {
			viewer.setInput(compiles);
		} catch (Exception ex) {
			ex.printStackTrace();
		}

		Composite buttons = new Composite(composite, SWT.NULL);
		buttons.setLayout(new GridLayout(1, false));
		buttons.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

		Button addWorkspaceButton = createButton("Add Directory", buttons);
		addWorkspaceButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent evt) {
				ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(getShell(),
						new WorkbenchLabelProvider(), new WorkbenchContentProvider());
				dialog.setAllowMultiple(false);
				dialog.addFilter(new ViewerFilter() {
					public boolean select(Viewer viewer, Object parentElement, Object element) {
						if (element.equals(getProject()) || element instanceof IFolder) {
							return true;
						}
						return false;
					}
				});
				dialog.setTitle("Add Directory");
				dialog.setInput(getProject().getWorkspace().getRoot());

				if (dialog.open() == Dialog.OK) {
					Object[] results = dialog.getResult();
					for (int i = 0; i < results.length; i++) {
						CompileProperty prop = new CompileProperty();
						if (results[i] instanceof IProject) {
							prop.setDirectory("");
						} else {
							prop.setDirectory(((Folder) results[i]).getProjectRelativePath()
									.toString());
						}
						CreateBuildSettingDialog dialog2 = new CreateBuildSettingDialog(
								getShell(), getProject(), prop);
						if (dialog2.open() == Dialog.OK) {
							compiles.add(prop);
							viewer.refresh();
						}
						dialog2 = null;
					}

				}
			}
		});

		Button settingButton = createButton("Setting", buttons);
		settingButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection sel = (IStructuredSelection) viewer.getSelection();
				if (sel.size() > 0) {
					CreateBuildSettingDialog dialog2 = new CreateBuildSettingDialog(getShell(),
							getProject(), (CompileProperty) sel.getFirstElement());
					dialog2.open();
					dialog2 = null;
					viewer.refresh();
				}
			}
		});
		Button removeButton = createButton("Remove", buttons);
		removeButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection sel = (IStructuredSelection) viewer.getSelection();
				compiles.removeAll(sel.toList());
				viewer.refresh();
			}
		});

		return composite;
	}

	protected void performDefaults() {
		this.compiles.clear();
		this.viewer.refresh();
	}

	public boolean performOk() {
		IPreferenceStore store = getPreferenceStore();
		store.setValue(AIRPlugin.PREF_FLEX_COMPILES, CompileProperty.export(compiles));

		WorkbenchPlugin.getDefault().getDecoratorManager().updateForEnablementChange();
		AirBuilderManager.doClean(getProject());
		return true;
	}

	private Button createButton(String text, Composite parent) {
		Button button = new Button(parent, SWT.PUSH);
		button.setText(text);
		button.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		return button;
	}

}
