package net.sf.amateras.air.preferences;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

/**
 * Initializes preferences.
 * 
 * @author Naoki Takezoe
 */
public class AIRPreferenceInitializer extends AbstractPreferenceInitializer {

	public void initializeDefaultPreferences() {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		store.setDefault(AIRPlugin.PREF_AIR_SDK_PATH, "");
		store.setDefault(AIRPlugin.PREF_FLEX_SDK_PATH, "");
		store.setDefault(AIRPlugin.PREF_DESCRIPTOR, "application.xml");
		store.setDefault(AIRPlugin.PREF_FLEX_LIBRARIES, "");
		store.setDefault(AIRPlugin.PREF_COLOR_DEFAULT, StringConverter.asString(new RGB(0, 0, 0)));
		store
				.setDefault(AIRPlugin.PREF_COLOR_COMMENT, StringConverter.asString(new RGB(0, 128,
						0)));
		store.setDefault(AIRPlugin.PREF_COLOR_STRING, StringConverter.asString(new RGB(0, 0, 255)));
		store.setDefault(AIRPlugin.PREF_COLOR_KEYWORD, StringConverter
				.asString(new RGB(128, 0, 128)));

		store.setDefault(AIRPlugin.PREF_FLEX_COMPILE_COMMAND, "mxmlc");
		store
				.setDefault(AIRPlugin.PREF_FLEX_COMPILE_OPTION,
						"+configname=air ${PROJECT_NAME}.mxml -output ${PROJECT_NAME}.swf -library-path+=${LIBRARY_PATH} ");
		store.setDefault(AIRPlugin.PREF_AS3_COMPILE_COMMAND, "compc");
		store
				.setDefault(
						AIRPlugin.PREF_AS3_COMPILE_OPTION,
						"-output bin/${PROJECT_NAME}.swc -source-path ${DIRECTORY} -include-classes ${AS_FILES} -library-path+=${LIBRARY_PATH} ");

		store.setDefault(AIRPlugin.PREF_FLEX_COMPILES, "\tmxmlc\t"
				+ store.getDefaultString(AIRPlugin.PREF_FLEX_COMPILE_OPTION) + "\t1\tfalse");
		String osName = System.getProperty("os.name");
		boolean isWindows = osName.indexOf("Windows") >= 0;

		if (isWindows) {
			store.setDefault(AIRPlugin.PREF_FCSH_SHELL_COMMAND, "bin/fcsh.exe");
			store.setDefault(AIRPlugin.PREF_ADL_COMMAND, "bin/adl.exe");
			store.setDefault(AIRPlugin.PREF_ADT_COMMAND, "bin/adt.bat");
			store.setValue(AIRPlugin.PREF_FONT_MATTING_SIZE, -2);
		} else {
			store.setDefault(AIRPlugin.PREF_FCSH_SHELL_COMMAND, "bin/fcsh");
			store.setDefault(AIRPlugin.PREF_ADL_COMMAND, "bin/adl");
			store.setDefault(AIRPlugin.PREF_ADT_COMMAND, "bin/adt");
			store.setValue(AIRPlugin.PREF_FONT_MATTING_SIZE, 0);
		}

		store.setDefault(AIRPlugin.PREF_COMPILE_MESSAGE_PATTERN, AIRPlugin
				.getResourceString("COMPILE_MESSAGE_PATTERN"));
		store.setDefault(AIRPlugin.PREF_COMPILE_FAIL_PATTERN, AIRPlugin
				.getResourceString("COMPILE_FAIL_PATTERN"));
		store.setDefault(AIRPlugin.PREF_COMPILE_ERROR_PATTERN, AIRPlugin
				.getResourceString("COMPILE_ERROR_PATTERN"));
		store.setDefault(AIRPlugin.PREF_COMPILE_WARNING_PATTERN, AIRPlugin
				.getResourceString("COMPILE_WARNING_PATTERN"));

		store.setDefault(AIRPlugin.PREF_COMPILE_FAIL_PATTERN_2, AIRPlugin
				.getResourceString("COMPILE_FAIL_PATTERN_2"));
		store.setDefault(AIRPlugin.PREF_COMPILE_ERROR_PATTERN_2, AIRPlugin
				.getResourceString("COMPILE_ERROR_PATTERN_2"));
		store.setDefault(AIRPlugin.PREF_COMPILE_WARNING_PATTERN_2, AIRPlugin
				.getResourceString("COMPILE_WARNING_PATTERN_2"));

	}

}
