package net.sf.amateras.air.preferences;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * 
 * @author ogawahideko
 */
public class AIRCompilePreferencePage extends PreferencePage implements IWorkbenchPreferencePage {

	private Text compileMessage;

	private Text compileFailPattern;
	private Text compileErrorPattern;
	private Text compileWarningPattern;

	private Text compileFailPattern2;
	private Text compileErrorPattern2;
	private Text compileWarningPattern2;

	private Button isAddInfoMarker;

	public AIRCompilePreferencePage() {
		super("AIR GEAR - Compile Option");
		setPreferenceStore(AIRPlugin.getDefault().getPreferenceStore());
	}

	protected Control createContents(Composite parent) {
		IPreferenceStore stote = getPreferenceStore();

		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		Group group = new Group(composite, SWT.NULL);
		group.setText(AIRPlugin.getResourceString("COMPILE_MATCH_PATTERN"));
		group.setLayout(new GridLayout(1, false));
		group.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Composite composite2 = new Composite(group, SWT.NULL);
		composite2.setLayout(new GridLayout(2, false));
		composite2.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		compileMessage = addText(composite2, "ID");
		compileMessage.setText(stote.getString(AIRPlugin.PREF_COMPILE_MESSAGE_PATTERN));
		
		Group gerror = new Group(group, SWT.NULL);
		gerror.setLayout(new GridLayout(2, false));
		gerror.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compileErrorPattern = addText(gerror, "Error");
		compileErrorPattern.setText(stote.getString(AIRPlugin.PREF_COMPILE_ERROR_PATTERN));
		compileErrorPattern2 = addText(gerror, "Error(2)");
		compileErrorPattern2.setText(stote.getString(AIRPlugin.PREF_COMPILE_ERROR_PATTERN_2));

		Group gwarn = new Group(group, SWT.NULL);
		gwarn.setLayout(new GridLayout(2, false));
		gwarn.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compileWarningPattern = addText(gwarn, "Warnig");
		compileWarningPattern.setText(stote.getString(AIRPlugin.PREF_COMPILE_WARNING_PATTERN));
		compileWarningPattern2 = addText(gwarn, "Warnig(2)");
		compileWarningPattern2.setText(stote.getString(AIRPlugin.PREF_COMPILE_WARNING_PATTERN_2));

		Group gfail = new Group(group, SWT.NULL);
		gfail.setLayout(new GridLayout(2, false));
		gfail.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compileFailPattern = addText(gfail, "Failure");
		compileFailPattern.setText(stote.getString(AIRPlugin.PREF_COMPILE_FAIL_PATTERN));
		compileFailPattern2 = addText(gfail, "Failure(2)");
		compileFailPattern2.setText(stote.getString(AIRPlugin.PREF_COMPILE_FAIL_PATTERN_2));

		isAddInfoMarker = new Button(composite, SWT.CHECK);
		isAddInfoMarker.setText(AIRPlugin.getResourceString("COMPILE_IS_ADD_INFO_MARKER"));
		isAddInfoMarker.setSelection(stote.getBoolean(AIRPlugin.PREF_IS_ADD_MARKER_COMPILE_INFO));

		return composite;
	}

	private Text addText(Composite parent, String label) {
		UIUtil.createLabel(label, parent);
		final Text text = new Text(parent, SWT.BORDER);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		return text;
	}

	public void init(IWorkbench workbench) {
		// Nothing to do.
	}

	protected void performDefaults() {
		IPreferenceStore stote = getPreferenceStore();
		compileMessage.setText(stote.getDefaultString(AIRPlugin.PREF_COMPILE_MESSAGE_PATTERN));
		compileErrorPattern.setText(stote.getDefaultString(AIRPlugin.PREF_COMPILE_ERROR_PATTERN));
		compileWarningPattern.setText(stote
				.getDefaultString(AIRPlugin.PREF_COMPILE_WARNING_PATTERN));
		compileFailPattern.setText(stote.getDefaultString(AIRPlugin.PREF_COMPILE_FAIL_PATTERN));
		compileErrorPattern2
				.setText(stote.getDefaultString(AIRPlugin.PREF_COMPILE_ERROR_PATTERN_2));
		compileWarningPattern2.setText(stote
				.getDefaultString(AIRPlugin.PREF_COMPILE_WARNING_PATTERN_2));
		compileFailPattern2.setText(stote.getDefaultString(AIRPlugin.PREF_COMPILE_FAIL_PATTERN_2));
		isAddInfoMarker.setSelection(stote
				.getDefaultBoolean(AIRPlugin.PREF_IS_ADD_MARKER_COMPILE_INFO));
		super.performDefaults();
	}

	public boolean performOk() {
		IPreferenceStore stote = getPreferenceStore();
		stote.setValue(AIRPlugin.PREF_COMPILE_MESSAGE_PATTERN, compileMessage.getText());
		stote.setValue(AIRPlugin.PREF_COMPILE_ERROR_PATTERN, compileErrorPattern.getText());
		stote.setValue(AIRPlugin.PREF_COMPILE_WARNING_PATTERN, compileWarningPattern.getText());
		stote.setValue(AIRPlugin.PREF_COMPILE_FAIL_PATTERN, compileFailPattern.getText());
		stote.setValue(AIRPlugin.PREF_COMPILE_ERROR_PATTERN_2, compileErrorPattern2.getText());
		stote.setValue(AIRPlugin.PREF_COMPILE_WARNING_PATTERN_2, compileWarningPattern2.getText());
		stote.setValue(AIRPlugin.PREF_COMPILE_FAIL_PATTERN_2, compileFailPattern2.getText());
		stote.setValue(AIRPlugin.PREF_IS_ADD_MARKER_COMPILE_INFO, isAddInfoMarker.getSelection());
		return true;
	}

}
