package net.sf.amateras.air.natures;

import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.CompileProperty;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/**
 * LabelDecorator of Source Directory Folder.
 * @author ogawahideko
 *
 */
public class SourceDirectoryFolder implements ILabelDecorator {

	public Image decorateImage(Image image, Object element) {
		if (element instanceof IFolder) {
			IProject project = ((IFolder) element).getProject();

			try {
				if (project.getNature(AIRFlexProjectNature.NATURE_ID) != null) {
					ScopedPreferenceStore store = new ScopedPreferenceStore(new ProjectScope(
							project), AIRPlugin.PLUGIN_ID);
					List<CompileProperty> props = CompileProperty.load(store);
					for (CompileProperty prop : props) {
						if (prop.getDirectory().equals(
								((IFolder) element).getProjectRelativePath().toString())) {
							return AIRPlugin.getDefault().getImageRegistry().get("SOURCE_FOLDER");
						}
					}
				}
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
		return image;
	}

	public String decorateText(String text, Object element) {
		return text;
	}

	public void addListener(ILabelProviderListener listener) {
		// nothing todo.
	}

	public void dispose() {
		// nothing todo.
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
		// nothing todo.
	}

}
