package net.sf.amateras.air.natures;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class ReadStreamThread extends Thread {

	private InputStream in;
	private PrintStream out;
	private boolean finished;

	public ReadStreamThread(InputStream in, PrintStream out) {
		this.in = in;
		this.out = out;
	}

	public void run() {
		try {
			byte[] buf = new byte[1024 * 8];
			int length = 0;
			while ((length = in.read(buf)) > 0) {
				out.print(new String(buf, 0, length));
			}
		} catch (IOException ex) {
		} finally {
			try {
				in.close();
			} catch (IOException ex) {
			}
		}
		finished = true;
	}

	public boolean isFinished() {
		return this.finished;
	}
}