package net.sf.amateras.air.natures;

import java.util.ArrayList;

import net.sf.amateras.air.builder.AirBuilderManager;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

/**
 * 
 * @author Naoki Takezoe
 */
public class AIRFlexProjectNature implements IProjectNature {

	public static final String NATURE_ID = "net.sf.amateras.air.AIRFlexProjectNature";

	private IProject project;

	public void configure() throws CoreException {
		IProjectDescription desc = project.getDescription();
		ICommand[] commands = desc.getBuildSpec();
		for (int i = 0; i < commands.length; i++) {
			if (commands[i].getBuilderName().equals(AirBuilderManager.BUILDER_ID)) {
				return;
			}
		}
		ICommand command = desc.newCommand();
		command.setBuilderName(AirBuilderManager.BUILDER_ID);
		ICommand[] newCommands = new ICommand[commands.length + 1];
		for (int i = 0; i < commands.length; i++) {
			newCommands[i] = commands[i];
		}
		newCommands[newCommands.length - 1] = command;
		desc.setBuildSpec(newCommands);
		project.setDescription(desc, null);
	}

	public void deconfigure() throws CoreException {
		IProjectDescription desc = project.getDescription();
		ICommand[] commands = desc.getBuildSpec();
		ArrayList<ICommand> list = new ArrayList<ICommand>();
		for (int i = 0; i < commands.length; i++) {
			if (!commands[i].getBuilderName().equals(AirBuilderManager.BUILDER_ID)) {
				list.add(commands[i]);
			}
		}
		desc.setBuildSpec((ICommand[]) list.toArray(new ICommand[list.size()]));
		project.setDescription(desc, null);
	}

	public IProject getProject() {
		return project;
	}

	public void setProject(IProject project) {
		this.project = project;
	}

}
