package net.sf.amateras.air.mxml.parser;

import net.sf.amateras.air.mxml.MXMLLoader;
import net.sf.amateras.air.mxml.models.DataGridModel;
import net.sf.amateras.air.mxml.models.IModel;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * 
 * @author ogawahideko
 */
public class DataGridParser extends AbstractMXMLParser {

	@Override
	protected IModel createModel() {
		return new DataGridModel();
	}

	@Override
	protected void parseChildElement(IModel model, Element node) {
		if (node.getNodeName().equalsIgnoreCase("mx:columns")) {
			NodeList nodeList = node.getChildNodes();
			int size = nodeList.getLength();
			for (int i = 0; i < size; i++) {
				Node childNode = nodeList.item(i);
				if (childNode.getNodeType() == Node.ELEMENT_NODE) {
					if (childNode.getNodeName().equalsIgnoreCase("mx:DataGridColumn")) {
						MXMLLoader.parseElement(model, (Element) childNode);
					}
				}
			}
		} else {
			model.addAdditionalChildElement(node);
		}
	}

}
