package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.core.WindowedApplication.
 * 
 * @author ogawahideko
 *
 */
public class WindowedApplicationModel extends ApplicationModel {
	private static String COMPONENT_NAME = "WindowedApplication";

	public static final String TITLE = "title";
	public static final String ALPHA = "alpha";
	public static final String BACKGROUND_ALPHA = "backgroundAlpha";

	public static final String ALWAYS_IN_FRONT = "alwaysInFront";
	public static final String AUTO_EXIT = "autoExit";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(TITLE, CATEGORY_PROPERTY);
		addDoubleModelProperty(ALPHA, CATEGORY_PROPERTY, null);
		addStringModelProperty(BACKGROUND_ALPHA, CATEGORY_PROPERTY);
		addBooleanModelProperty(ALWAYS_IN_FRONT, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(AUTO_EXIT, CATEGORY_PROPERTY, true);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

}
