package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.TextArea
 * 
 * @author Naoki Takezoe
 */
public class TextAreaModel extends AbstractScrollControllBase implements IContainerModel {
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "TextArea";

	public static final String CONDENSE_WHITE = "condenseWhite";
	public static final String DATA = "data";
	public static final String DISPLAY_AS_PASSWORD = "displayAsPassword";
	public static final String EDITABLE = "editable";
	public static final String HORIZONTAL_SCROLL_POLICY = "horizontalScrollPolicy";
	public static final String HORIZONTAL_SCROLL_POSITION = "horizontalScrollPosition";
	public static final String HTML_TEXT = "htmlText";
	public static final String IME_MODE = "imeMode";
	public static final String LENGTH = "length";
	public static final String LIST_DATA = "listData";
	public static final String MAX_CHARS = "maxChars";
	public static final String RESTRICT = "restrict";
	public static final String SELECTABLE = "selectable";
	public static final String SELECTION_BEGIN_INDEX = "selectionBeginIndex";
	public static final String SELECTION_END_INDEX = "selectionEndIndex";
	public static final String STYLE_SHEET = "styleSheet";
	public static final String TEXT = "text";
	public static final String TEXT_HEIGHT = "textHeight";
	public static final String TEXT_WIDTH = "textWidth";
	public static final String VERTICAL_SCROLL_POLICY = "verticalScrollPolicy";
	public static final String VERTICAL_SCROLL_POSITION = "verticalScrollPosition";
	public static final String WORD_WRAP = "wordWrap";

	public static final String DISABLED_COLOR = "disabledColor";
	public static final String FOCUS_ALPHA = "focusAlpha";
	public static final String FOCUS_ROUNDED_CORNERS = "focusRoundedCorners";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";

	public static final String CHANGE = "change";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(CONDENSE_WHITE, CATEGORY_PROPERTY, false);
		addStringModelProperty(DATA, CATEGORY_PROPERTY);
		addBooleanModelProperty(DISPLAY_AS_PASSWORD, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(EDITABLE, CATEGORY_PROPERTY, true);
		addListModelProperty(HORIZONTAL_SCROLL_POLICY, CATEGORY_PROPERTY, new String[] { "auto",
				"on", "off" });
		addNumberModelProperty(HORIZONTAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0);
		addStringModelProperty(HTML_TEXT, CATEGORY_PROPERTY);
		addListModelProperty(IME_MODE, CATEGORY_PROPERTY, LIST_IME_MODE);
		addNumberModelProperty(LENGTH, CATEGORY_PROPERTY, 0);
		addStringModelProperty(LIST_DATA, CATEGORY_PROPERTY);
		addNumberModelProperty(MAX_CHARS, CATEGORY_PROPERTY, 0);
		addStringModelProperty(RESTRICT, CATEGORY_PROPERTY);
		addBooleanModelProperty(SELECTABLE, CATEGORY_PROPERTY, false);
		addNumberModelProperty(SELECTION_BEGIN_INDEX, CATEGORY_PROPERTY, 0);
		addNumberModelProperty(SELECTION_END_INDEX, CATEGORY_PROPERTY, 0);
		addStringModelProperty(STYLE_SHEET, CATEGORY_PROPERTY);
		addStringModelProperty(TEXT, CATEGORY_PROPERTY);
		addWidthHeightModelProperty(TEXT_HEIGHT, CATEGORY_PROPERTY, "");
		addWidthHeightModelProperty(TEXT_WIDTH, CATEGORY_PROPERTY, "");
		addListModelProperty(VERTICAL_SCROLL_POLICY, CATEGORY_PROPERTY, new String[] { "auto",
				"on", "off" });
		addNumberModelProperty(VERTICAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0);
		addListModelProperty(WORD_WRAP, CATEGORY_PROPERTY, new String[] { "true", "false" });

		//styles
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("0xAAB3B3"));
		addDoubleModelProperty(FOCUS_ALPHA, CATEGORY_STYLE, 0.5);
		addStringModelProperty(TEXT, CATEGORY_PROPERTY);
		addBooleanModelProperty(EDITABLE, CATEGORY_PROPERTY, true);
		addNumberModelProperty(MAX_CHARS, CATEGORY_PROPERTY, 0);
		addStringModelProperty(RESTRICT, CATEGORY_PROPERTY);
		addStringModelProperty(FOCUS_ROUNDED_CORNERS, CATEGORY_PROPERTY);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_PROPERTY, 0);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_PROPERTY, 0);

		addStringModelProperty(CHANGE, CATEGORY_EVENT);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}


	/**
	 * Whether it is possible to add it as a child component or not?
	 * If it is DataGridColumnModel, it is OK.
	 * @param model
	 * @return
	 */
	@Override
	public boolean canChildComponent(Object model) {
		if (model == null) {
			return false;
		} else if (model instanceof TextInputModel) {
			return true;
		} else {
			return false;
		}
	}

}
