package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.RadioButton
 * 
 * @author ogawahideko
 */
public class RadioButtonModel extends ButtonModel {
	public static final String COMPONENT_NAME = "RadioButton";

	public static final String GROUP_NAME = "groupName";
	public static final String LABEL_PLACEMENT = "labelPlacement";

	public static final String DISABLED_ICON_COLOR = "disabledIconColor";
	public static final String ICON_COLOR = "iconColor";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		//Property Override
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);

		//Properties
		addStringModelProperty(GROUP_NAME, CATEGORY_PROPERTY);
		addListModelProperty(LABEL_PLACEMENT, CATEGORY_PROPERTY, LIST_LABEL_PLACEMENT);

		//Styles
		addColorModelProperty(DISABLED_ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("999999"));
		addColorModelProperty(ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("2B333C"));
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	public int getDefaultWidth() {
		return 56;
	}

	public int getDefaultHeight() {
		return 22;
	}

}
