package net.sf.amateras.air.mxml.models;

/**
 * The GEF model for the <code>mx.controls.Image</code>.
 * 
 * @author Naoki Takezoe
 */
public class ImageModel extends SWFLoaderModel {
	public static final String COMPONENT_NAME = "Image";
	public static final String PACKAGE_NAME = "mx.controls";

	public static final String SOURCE = "source";

	public static final String DATA_CHANGE = "dataChange";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addImageModelProperty(SOURCE, CATEGORY_PROPERTY);

		addStringModelProperty(DATA_CHANGE, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	public int getDefaultWidth() {
		return 32;
	}

	public int getDefaultHeight() {
		return 32;
	}
}
