package net.sf.amateras.air.mxml.models;

import java.util.List;
import java.util.Map;

import org.w3c.dom.Element;

public interface IModel {
	public static final String CATEGORY_PROPERTY = "Properties";
	public static final String CATEGORY_STYLE = "Styles";
	public static final String CATEGORY_EVENT = "Events";
	public static final String CATEGORY_EFFECT = "Effects";
	public static final String CATEGORY_LAYOUT = "Layout";

	public static final String CATEGORY_COMMON_PROPERTY = "Properties";
	public static final String CATEGORY_COMMON_EVENT = "Events";

	public static final String ID = "id";
	public static final String X = "x";
	public static final String Y = "y";
	public static final String WIDTH = "width";
	public static final String HEIGHT = "height";

	public Object getAttribute(String propertyName);

	public String getAttributeToString(String propertyName);

	public void addAdditionalChildElement(Element childNode);

	public List<Element> getAdditionalChildElements();

	public void setAdditionalAttributes(Map additionalAttributes);

	public Map getAdditionalAttributes();

	public Map getModelProperties();

	public void resetPropertyValue(Object id);

	public void setPropertyValue(Object id, Object value);

}
