package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.containers.Form.
 * 
 * @author ogawahideko
 *
 */
public class FormModel extends AbstractContainerModel {
	private static final String COMPONENT_NAME = "Form";

	private static final String HORIZONTAL_GAP = "horizontalGap";
	private static final String INDICATOR_GAP = "indicatorGap";
	private static final String LABEL_WIDTH = "labelWidth";

	private static final String PADDING_BOTTOM = "paddingBottom";
	private static final String PADDING_TOP = "paddingTop";
	private static final String VERTICAL_GAP = "verticalGap";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();

		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 8);
		addNumberModelProperty(INDICATOR_GAP, CATEGORY_STYLE, 14);
		addNumberModelProperty(LABEL_WIDTH, CATEGORY_STYLE);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 16);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 16);
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, 6);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	public int getDefaultWidth() {
		return 100;
	}

	public int getDefaultHeight() {
		return 50;
	}
}
