package net.sf.amateras.air.mxml.models;

import org.eclipse.draw2d.geometry.Rectangle;

/**
 * Rectangle for flex.
 * x,y,width,height local property is real size.
 * strX, strY, strWidth, strHeight is property value.
 * 
 * @author ogawahideko
 *
 */
@SuppressWarnings("serial")
public class FlexRectangle extends Rectangle implements Cloneable {

	// "**%", "" etc..
	private String strX;
	private String strY;
	private String strWidth = "";
	private String strHeight = "";

	public FlexRectangle() {

	}

	public void setRectangle(int x, int y, int width, int height) {
		strX = String.valueOf(x);
		this.x = x;

		strY = String.valueOf(y);
		this.y = y;

		strWidth = String.valueOf(width);
		this.width = width;

		strHeight = String.valueOf(height);
		this.height = height;
	}

	public void setWidth(int width) {
		strWidth = String.valueOf(width);
		this.width = width;
	}

	public void setStrWidth(String strWidth) {
		this.strWidth = strWidth.trim();
		if (strWidth != null && strWidth.length() != 0 && !(strWidth.endsWith("%"))) {
			try {
				width = Integer.parseInt(strWidth);
			} catch (NumberFormatException e) {
				width = -1;
			}
		} else {
			width = -1;
		}
	}

	public void setStrHeight(String strHeight) {
		this.strHeight = strHeight.trim();
		if (strHeight != null && strHeight.length() != 0 && !(strHeight.endsWith("%"))) {
			try {
				height = Integer.parseInt(strHeight);
			} catch (NumberFormatException e) {
				height = -1;
			}
		} else {
			height = -1;
		}
	}

	// setHeight
	// ---------------------------------------------------
	public void setHeight(int height) {
		strHeight = String.valueOf(height);
		this.height = height;
	}

	public String getStrWidth() {
		return strWidth;
	}

	public String getStrHeight() {
		return strHeight;
	}

	public void setX(int x) {
		strX = String.valueOf(x);
		this.x = x;
	}

	public void setY(int y) {
		strY = String.valueOf(y);
		this.y = y;
	}

	public String getStrX() {
		return strX;
	}

	public void setStrX(String strX) {
		this.strX = strX.trim();
		if (strX != null && strX.length() != 0 && !(strX.endsWith("%"))) {
			x = Integer.parseInt(strX);
		}
	}

	public String getStrY() {
		return strY;
	}

	public void setStrY(String strY) {
		this.strY = strY.trim();
		if (strY != null && strY.length() != 0 && !(strY.endsWith("%"))) {
			y = Integer.parseInt(strY);
		}
	}

	@Override
	public String toString() {
		return super.toString() + " String[" + strX + "," + strY + "," + strWidth + "," + strHeight
				+ "]";
	}

	@Override
	public FlexRectangle clone() {
		FlexRectangle rectangle = new FlexRectangle();
		rectangle.strHeight = strHeight;
		rectangle.strWidth = strWidth;
		rectangle.strX = strX;
		rectangle.strY = strY;
		rectangle.x = x;
		rectangle.y = y;
		rectangle.width = width;
		rectangle.height = height;
		return rectangle;
	}

}
