package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.controls.FileSystemDataGrid.
 * 
 * @author ogawahideko
 */
public class FileSystemDataGridModel extends DataGridModel {
	public static final String COMPONENT_NAME = "FileSystemDataGrid";
	public static final String PACKAGE_NAME = "mx.controls";

	public static final String DIRECTORY = "directory";
	public static final String ENUMERATION_MODE = "enumerationMode";
	public static final String EXTENSIONS = "extensions";
	public static final String FILTER_FUNCTION = "filterFunction";
	public static final String NAME_COMPARE_FUNCTION = "nameCompareFunction";
	public static final String SELECTED_PATH = "selectedPath";
	public static final String SELECTED_PATHS = "selectedPaths";
	public static final String SHOW_EXTENSIONS = "showExtensions";
	public static final String SHOW_HIDDEN = "showHidden";
	public static final String SHOW_ICONS = "showIcons";
	
	public static final String DIRECTORY_ICON = "directoryIcon";
	public static final String FILE_ICON = "fileIcon";
	
	public static final String DIRECTORY_CHANGE = "directoryChange";
	public static final String DIRECTORY_CHANGING = "directoryChanging";
	public static final String FILE_CHOOSE = "fileChoose";


	/**
	 * implement {@link IInstallDefault}
	 */
	public void installDefault() {
		//Nothing todo.
	}

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(DIRECTORY, CATEGORY_PROPERTY);
		addStringModelProperty(ENUMERATION_MODE, CATEGORY_PROPERTY);
		addStringModelProperty(EXTENSIONS, CATEGORY_PROPERTY);
		addStringModelProperty(FILTER_FUNCTION, CATEGORY_PROPERTY);
		addStringModelProperty(NAME_COMPARE_FUNCTION, CATEGORY_PROPERTY);
		addStringModelProperty(SELECTED_PATH, CATEGORY_PROPERTY);
		addStringModelProperty(SELECTED_PATHS, CATEGORY_PROPERTY);
		addBooleanModelProperty(SHOW_EXTENSIONS, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_HIDDEN, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(SHOW_ICONS, CATEGORY_PROPERTY, true);
		
		addImageModelProperty(DIRECTORY_ICON, CATEGORY_STYLE);
		addImageModelProperty(FILE_ICON, CATEGORY_STYLE);
		
		addStringModelProperty(DIRECTORY_CHANGE, CATEGORY_EVENT);
		addStringModelProperty(DIRECTORY_CHANGING, CATEGORY_EVENT);
		addStringModelProperty(FILE_CHOOSE, CATEGORY_EVENT);
	}


	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}



}
