package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.controls.FileSystemComboBox.
 * 
 * @author ogawahideko
 *
 */
public class FileSystemComboBoxModel extends ComboBoxModel implements IInstallDefault {
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "FileSystemComboBox";

	public static final String DIRECTORY = "directory";
	public static final String INDENT = "indent";
	public static final String SHOW_ICONS = "showIcons";

	public static final String COMPUTER_ICON = "computerIcon";
	public static final String DIRECTORY_ICON = "directoryIcon";

	public static final String DIRECTORY_CHANGE = "directoryChange";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(DIRECTORY, CATEGORY_PROPERTY);
		addNumberModelProperty(INDENT, CATEGORY_PROPERTY, 8);
		addBooleanModelProperty(SHOW_ICONS, CATEGORY_PROPERTY, true);

		addImageModelProperty(COMPUTER_ICON, CATEGORY_STYLE);
		addImageModelProperty(DIRECTORY_ICON, CATEGORY_STYLE);

		addStringModelProperty(DIRECTORY_CHANGE, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	/**
	 * implement {@link IInstallDefault}
	 */
	public void installDefault() {
		setAttribute(DIRECTORY, "{File.desktopDirectory}");
	}
}
