package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.DataGrid.
 * 
 * @author ogawahideko
 */
public class DataGridModel extends AbstractListBase implements IContainerModel, IInstallDefault {
	public static final String COMPONENT_NAME = "DataGrid";
	public static final String PACKAGE_NAME = "mx.controls";

	public static final String COLUMNS = "columns";
	public static final String DRAGGABLE_COLIMNS = "draggableColumns";
	public static final String EDITABLE = "editable";
	public static final String EDITED_ITEM_POSITION = "editedItemPosition";
	public static final String HORIZONTAL_SCROLL_POSITION = "horizontalScrollPosition";
	public static final String IME_MODE = "imeMode";
//	public static final String ITEM_EDITOR_INSTANCE = "itemEditorInstance";
	public static final String MIN_COLUMN_WIDTH = "minColumnWidth";
	public static final String RESIZABLE_COLUMNS = "resizableColumns";
	public static final String SORTABLE_COLUMNS = "sortableColumns";
	
	public static final String BACKGROUND_DISABLED_COLOR = "backgroundDisabledColor";
	public static final String COLUMN_DROP_INDICATOR_SKIN = "columnDropIndicatorSkin";
	public static final String COLUMN_RESIZE_SKIN = "columnResizeSkin";
	public static final String DISABLED_ICON_COLOR = "disabledIconColor";
	public static final String HEADER_COLORS = "headerColors";
	public static final String HEADER_DRAG_STYLE_NAME = "headerDragProxyStyleName";
	public static final String HEADER_SEPARATOR_SKIN = "headerSeparatorSkin";
	public static final String HEADER_STYLE_NAME = "headerStyleName";
	public static final String HORIZONTAL_GRID_LINE_COLOR = "horizontalGridLineColor";
	public static final String HORIZONTAL_GRID_LINES = "horizontalGridLines";
	public static final String HORIZONTAL_LOCLED_SEPARATOR_SKIN = "horizontalLockedSeparatorSkin";
	public static final String HORIZONTAL_SEPARATOR_SKIN = "horizontalSeparatorSkin";
	public static final String ICON_COLOR = "iconColor";
	public static final String ROLL_OVER_COLOR = "rollOverColor";
	public static final String SELECTION_COLOR = "selectionColor";
	public static final String SORT_ARROW_SKIN = "sortArrowSkin";
	public static final String STRETCH_CURSOR = "stretchCursor";
	public static final String VERTICAL_GRID_LINE_COLOR = "verticalGridLineColor";
	public static final String VERTICAL_GRID_LINES = "verticalGridLines";
	public static final String VERTICAL_LOCKED_SEPARATOR_SKIN = "verticalLockedSeparatorSkin";
	public static final String VERTICAL_SEPARATOR_SKIN = "verticalSeparatorSkin";


	public static final String COLUMN_STRETCH = "columnStretch";
	public static final String HEADER_RELEASE = "headerRelease";
	public static final String HEADER_SHIFT = "headerShift";
	public static final String ITEM_EDIT_BEGIN = "itemEditBegin";
	public static final String ITEM_EDIT_BEGINNING = "itemEditBeginning";
	public static final String ITEM_EDIT_END = "itemEditEnd";
	public static final String ITEM_FOCUS_IN = "itemFocusIn";
	public static final String ITEM_FOCUS_OUT = "itemFocusOut";
	/**
	 * implement {@link IInstallDefault}
	 */
	public void installDefault() {
		addChild(new DataGridColumnModel("A"));
		addChild(new DataGridColumnModel("B"));
		addChild(new DataGridColumnModel("C"));
		fireChildPropertyChange();
	}

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		//Properties
		addStringModelProperty(COLUMNS, CATEGORY_PROPERTY);
		addBooleanModelProperty(DRAGGABLE_COLIMNS, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(EDITABLE, CATEGORY_PROPERTY, false);
		addStringModelProperty(EDITED_ITEM_POSITION, CATEGORY_PROPERTY);
		addNumberModelProperty(HORIZONTAL_SCROLL_POSITION, CATEGORY_PROPERTY);
		addListModelProperty(IME_MODE, CATEGORY_PROPERTY, LIST_IME_MODE);
		addNumberModelProperty(MIN_COLUMN_WIDTH, CATEGORY_PROPERTY);
		addBooleanModelProperty(RESIZABLE_COLUMNS, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SORTABLE_COLUMNS, CATEGORY_PROPERTY, true);
		
		//Styles
		addColorModelProperty(BACKGROUND_DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#EFEEEF"));
		addStringModelProperty(COLUMN_DROP_INDICATOR_SKIN, CATEGORY_STYLE);
		addStringModelProperty(COLUMN_RESIZE_SKIN, CATEGORY_STYLE);
		addColorModelProperty(DISABLED_ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#999999"));
		addStringModelProperty(HEADER_COLORS, CATEGORY_STYLE, "[#FFFFFF, #E6E6E6]");
		addStringModelProperty(HEADER_DRAG_STYLE_NAME, CATEGORY_STYLE);
		addStringModelProperty(HEADER_SEPARATOR_SKIN, CATEGORY_STYLE);
		addStringModelProperty(HEADER_STYLE_NAME, CATEGORY_STYLE);
		addColorModelProperty(HORIZONTAL_GRID_LINE_COLOR, CATEGORY_STYLE);
		addBooleanModelProperty(HORIZONTAL_GRID_LINES, CATEGORY_STYLE, false);
		addStringModelProperty(HORIZONTAL_LOCLED_SEPARATOR_SKIN, CATEGORY_STYLE);
		addStringModelProperty(HORIZONTAL_SEPARATOR_SKIN, CATEGORY_STYLE);
		addColorModelProperty(ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#111111"));
		addColorModelProperty(ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#E3FFD6"));
		addColorModelProperty(SELECTION_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#CDFFC1"));
		addStringModelProperty(SORT_ARROW_SKIN, CATEGORY_STYLE);
		addStringModelProperty(STRETCH_CURSOR, CATEGORY_STYLE);
		addColorModelProperty(VERTICAL_GRID_LINE_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#666666"));
		addBooleanModelProperty(VERTICAL_GRID_LINES, CATEGORY_STYLE, true);
		addStringModelProperty(VERTICAL_LOCKED_SEPARATOR_SKIN, CATEGORY_STYLE);
		addStringModelProperty(VERTICAL_SEPARATOR_SKIN, CATEGORY_STYLE);
		
		//Events
		addStringModelProperty(COLUMN_STRETCH, CATEGORY_EVENT);
		addStringModelProperty(HEADER_RELEASE, CATEGORY_EVENT);
		addStringModelProperty(HEADER_SHIFT, CATEGORY_EVENT);
		addStringModelProperty(ITEM_EDIT_BEGIN, CATEGORY_EVENT);
		addStringModelProperty(ITEM_EDIT_BEGINNING, CATEGORY_EVENT);
		addStringModelProperty(ITEM_EDIT_END, CATEGORY_EVENT);
		addStringModelProperty(ITEM_FOCUS_IN, CATEGORY_EVENT);
		addStringModelProperty(ITEM_FOCUS_OUT, CATEGORY_EVENT);
	}

	@Override
	protected String getChildrenXML() {
		if (getChildren().size() != 0) {
			StringBuilder sb = new StringBuilder();
			sb.append("<mx:columns>");
			sb.append(super.getChildrenXML());
			sb.append("</mx:columns>\n");
			return sb.toString();
		} else {
			return super.getChildrenXML();
		}
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}


	/**
	 * Whether it is possible to add it as a child component or not?
	 * If it is DataGridColumnModel, it is OK.
	 * @param model
	 * @return
	 */
	@Override
	public boolean canChildComponent(Object model) {
		if (model == null) {
			return false;
		} else if (model instanceof DataGridColumnModel) {
			return true;
		} else {
			return false;
		}
	}

}
