package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.core.Application
 * @author ogawahideko
 *
 */
public class ApplicationModel extends AbstractContainerModel {
	private static String COMPONENT_NAME = "Application";
	private static String PACKAGE_NAME = "mx.core";

	//application
	public static final String FRAME_RATE = "frameRate";
	public static final String HISTORY_MANAGEMENT_ENABLED = "historyManagementEnabled";
	public static final String LAYOUT = "layout";
	public static final String PAGE_TITLE = "pageTitle";
	public static final String PRELOADER = "preloader";
	public static final String RESET_HISTORY = "resetHistory";
	public static final String SCRIPT_RECURSION_LIMIT = "scriptRecursionLimit";
	public static final String SCRIPT_TIME_LIMIT = "scriptTimeLimit";
	public static final String USE_PRELOADER = "usePreloader";
	public static final String VIEW_SOURCE_URL = "viewSourceURL";

	public static final String BACKGROUND_GRADIENT_ALPAS = "backgroundGradientAlphas";
	public static final String BACKGROUND_GRADIENT_COLORS = "backgroundGradientColors";
	public static final String HORIZONTAL_ALIGN = "horizontalAlign";
	public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String MODAL_TRANSPARENCY = "modalTransparency";
	public static final String MODAL_TRANSPARENCY_BLUR = "modalTransparencyBlur";
	public static final String MODAL_TRANSPARENCY_COLOR = "modalTransparencyColor";
	public static final String MODALTRANSPARENCY_DURATION = "modalTransparencyDuration";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_TOP = "paddingTop";
	public static final String VERTICAL_ALIGN = "verticalAlign";
	public static final String VERTICAL_GAP = "verticalGap";

	public static final String APPLICATION_COMPLETE = "applicationComplete";
	public static final String ERROR = "error";

	public static final String INITIALIZE = "initialize";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();

		addNumberModelProperty(FRAME_RATE, CATEGORY_PROPERTY, 24);
		addBooleanModelProperty(HISTORY_MANAGEMENT_ENABLED, CATEGORY_PROPERTY, true);
		addListModelProperty(LAYOUT, CATEGORY_PROPERTY, new String[] { "vertical", "horizontal",
				"absolute" });
		addStringModelProperty(PAGE_TITLE, CATEGORY_PROPERTY);
		addStringModelProperty(PRELOADER, CATEGORY_PROPERTY);
		addBooleanModelProperty(RESET_HISTORY, CATEGORY_PROPERTY, true);
		addNumberModelProperty(SCRIPT_RECURSION_LIMIT, CATEGORY_PROPERTY, 1000);
		addNumberModelProperty(SCRIPT_TIME_LIMIT, CATEGORY_PROPERTY, 60);
		addBooleanModelProperty(USE_PRELOADER, CATEGORY_PROPERTY, true);
		addStringModelProperty(VIEW_SOURCE_URL, CATEGORY_PROPERTY);

		//style
		addStringModelProperty(BACKGROUND_GRADIENT_ALPAS, CATEGORY_STYLE);
		addStringModelProperty(BACKGROUND_GRADIENT_COLORS, CATEGORY_STYLE);
		addListModelProperty(HORIZONTAL_ALIGN, CATEGORY_STYLE, new String[] { "center", "left",
				"right" });
		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 8);
		addDoubleModelProperty(MODAL_TRANSPARENCY, CATEGORY_STYLE, 0.5);
		addNumberModelProperty(MODAL_TRANSPARENCY_BLUR, CATEGORY_STYLE, 3);
		addColorModelProperty(MODAL_TRANSPARENCY_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#DDDDDD"));
		addNumberModelProperty(MODALTRANSPARENCY_DURATION, CATEGORY_STYLE, 100);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 24);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 24);
		addListModelProperty(VERTICAL_ALIGN, CATEGORY_STYLE, new String[] { "top", "bottom",
				"middle" });
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, 6);

		//event
		addStringModelProperty(APPLICATION_COMPLETE, CATEGORY_EVENT);
		addStringModelProperty(ERROR, CATEGORY_EVENT);

		addStringModelProperty(INITIALIZE, CATEGORY_EVENT);

		//remove
		removePropertySheet(X);
		removePropertySheet(Y);
		removePropertySheet(ID);
		addWidthHeightModelProperty(WIDTH, CATEGORY_LAYOUT, "");
		addWidthHeightModelProperty(HEIGHT, CATEGORY_LAYOUT, "");

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}
	
	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	protected String getLocationAttributes() {
		return "";
	}


}
