package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * model of mx.controls.listClasses.ListBase.
 * 
 * @author ogawahideko
 */
public abstract class AbstractListBase extends AbstractScrollControllBase {

	//properties
	public static final String ALLOW_DRAG_SELECTION = "allowDragSelection";
	public static final String ALLOW_MULTIPLE_SELECTION = "allowMultipleSelection";
	public static final String COLUMN_COUNT = "columnCount";
	public static final String COLUMN_WIDTH = "columnWidth";
	public static final String DATA_PROVIDER = "dataProvider";
	public static final String DATA_TIP_FIELD = "dataTipField";
	public static final String DATA_TIP_FUNCTION = "dataTipFunction";
	public static final String DRAG_ENABLED = "dragEnabled";
	public static final String DRAG_MOVE_ENABLED = "dragMoveEnabled";
	public static final String DROP_ENABLED = "dropEnabled";
	public static final String ICON_FIELD = "iconField";
	public static final String ICON_FUNCTION = "iconFunction";
	public static final String ITEM_RENDERER = "itemRenderer";
	public static final String LABEL_FIELD = "labelField";
	public static final String LABEL_FUNCTION = "labelFunction";
	public static final String MENU_SELECTION_MODE = "menuSelectionMode";
	public static final String OFFSCREEN_EXTRA_ROWS_OR_COLUMNS = "offscreenExtraRowsOrColumns";
	public static final String ROW_COUNT = "rowCount";
	public static final String ROW_HEIGHT = "rowHeight";
	public static final String SELECTABLE = "selectable";
	public static final String SELECTED_INDEX = "selectedIndex";
	public static final String SELECTED_INDICES = "selectedIndices";
	public static final String SELECTED_ITEM = "selectedItem";
	public static final String SELECTED_ITEMS = "selectedItems";
	public static final String SHOW_DATA_TIPS = "showDataTips";
	public static final String VARIABLE_ROW_HEIGHT = "variableRowHeight";
	public static final String WORD_WRAP = "wordWrap";

	//styles
	public static final String ALTERNATING_ITEM_COLORS = "alternatingItemColors";
	//	public static final String DROP_INDICATOR_SKIN = "dropIndicatorSkin";
	//	public static final String FOCUS_ALPHA = "focusAlpha";
	//	public static final String FOCUS_ROUNDED_CORNERS = "focusRoundedCorners";
	public static final String ROLL_OVER_COLOR = "rollOverColor";
	public static final String SELECTION_COLOR = "selectionColor";
	public static final String SELECTION_DISABLED_COLOR = "selectionDisabledColor";
	public static final String SELECTION_DURATION = "selectionDuration";
	public static final String SELECTION_EASING_FUNCTION = "selectionEasingFunction";
	public static final String TEXT_ROLL_OVER_COLOR = "textRollOverColor";
	public static final String TEXT_SELECTED_COLOR = "textSelectedColor";
	public static final String USE_ROLL_OVER = "useRollOver";
	public static final String VERTICAL_ALIGN = "verticalAlign";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String PADDING_TOP = "paddingTop";

	//effect
	public static final String ITEMS_CHANGE_EFFECT = "itemsChangeEffect";

	//events
	public static final String CHANGE = "change";
	public static final String DATA_CHANGE = "dataChange";
	public static final String ITEM_CLICK = "itemClick";
	public static final String ITEM_DOUBLE_CLICK = "itemDoubleClick";
	public static final String ITEM_ROLL_OUT = "itemRollOut";
	public static final String ITEM_ROLL_OVER = "itemRollOver";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(ALLOW_DRAG_SELECTION, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(ALLOW_MULTIPLE_SELECTION, CATEGORY_PROPERTY, false);
		addNumberModelProperty(COLUMN_COUNT, CATEGORY_PROPERTY, 4);
		addNumberModelProperty(COLUMN_WIDTH, CATEGORY_PROPERTY);
		addStringModelProperty(DATA_PROVIDER, CATEGORY_PROPERTY);
		addStringModelProperty(DATA_TIP_FIELD, CATEGORY_PROPERTY);
		addStringModelProperty(DATA_TIP_FUNCTION, CATEGORY_PROPERTY);
		addBooleanModelProperty(DRAG_ENABLED, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(DRAG_MOVE_ENABLED, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(DROP_ENABLED, CATEGORY_PROPERTY, false);
		addStringModelProperty(ICON_FIELD, CATEGORY_PROPERTY);
		addStringModelProperty(ICON_FUNCTION, CATEGORY_PROPERTY);
		addStringModelProperty(ITEM_RENDERER, CATEGORY_PROPERTY);
		addStringModelProperty(LABEL_FIELD, CATEGORY_PROPERTY);
		addStringModelProperty(LABEL_FUNCTION, CATEGORY_PROPERTY);
		addBooleanModelProperty(MENU_SELECTION_MODE, CATEGORY_PROPERTY, false);
		addNumberModelProperty(OFFSCREEN_EXTRA_ROWS_OR_COLUMNS, CATEGORY_PROPERTY, 0);
		addNumberModelProperty(ROW_COUNT, CATEGORY_PROPERTY, -1);
		addNumberModelProperty(ROW_HEIGHT, CATEGORY_PROPERTY);
		addBooleanModelProperty(SELECTABLE, CATEGORY_PROPERTY, true);
		addNumberModelProperty(SELECTED_INDEX, CATEGORY_PROPERTY, -1);
		addStringModelProperty(SELECTED_INDICES, CATEGORY_PROPERTY);
		addStringModelProperty(SELECTED_ITEM, CATEGORY_PROPERTY);
		addStringModelProperty(SELECTED_ITEMS, CATEGORY_PROPERTY);
		addBooleanModelProperty(SHOW_DATA_TIPS, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(VARIABLE_ROW_HEIGHT, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(WORD_WRAP, CATEGORY_PROPERTY, false);

		//effects
		addStringModelProperty(ITEMS_CHANGE_EFFECT, CATEGORY_EFFECT);

		//Styles
		addStringModelProperty(ALTERNATING_ITEM_COLORS, CATEGORY_STYLE);
		addColorModelProperty(ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#EEFEE6"));
		addColorModelProperty(SELECTION_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#7FCEFF"));
		addColorModelProperty(SELECTION_DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#DDDDDD"));
		addNumberModelProperty(SELECTION_DURATION, CATEGORY_STYLE, 250);
		addStringModelProperty(SELECTION_EASING_FUNCTION, CATEGORY_STYLE);

		addColorModelProperty(TEXT_ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C"));
		addColorModelProperty(TEXT_SELECTED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C"));

		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 2);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 2);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 2);

		addBooleanModelProperty(USE_ROLL_OVER, CATEGORY_STYLE, true);
		addListModelProperty(VERTICAL_ALIGN, CATEGORY_STYLE, new String[] { "top", "middle",
				"bottom" });

	}
}
