package net.sf.amateras.air.mxml.models;

public abstract class AbstractComboBase extends AbstractContainerModel {

	//properties
	public static final String DATA_PROVIDER = "dataProvider";
	public static final String EDITABLE = "editable";
	public static final String IME_MODE = "imeMode";
	public static final String RESTRICT = "restrict";
	public static final String SELECTED_INDEX = "selectedIndex";
	public static final String SELECTED_ITEM = "selectedItem";
	public static final String TEXT = "text";
	
	//Styles
	public static final String DISABLED_SKIN = "disabledSkin";
	public static final String DOWN_SKIN = "downSkin";
	public static final String EDITABLE_DISABLED_SKIN = "editableDisabledSkin";
	public static final String EDITABLE_DOWN_SKIN = "editableDownSkin";
	public static final String EDITABLE_OVER_SKIN = "editableOverSkin";
	public static final String EDITABLE_UP_SKIN = "editableUpSkin";
	public static final String OVER_SKIN = "overSkin";
	public static final String TEXT_INPUT_STYLE_NAME = "textInputStyleName";
	public static final String UP_SKIN = "upSkin";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(DATA_PROVIDER, CATEGORY_PROPERTY);
		addBooleanModelProperty(EDITABLE, CATEGORY_PROPERTY, false);
		addStringModelProperty(IME_MODE, CATEGORY_PROPERTY);
		addStringModelProperty(RESTRICT, CATEGORY_PROPERTY);
		addNumberModelProperty(SELECTED_INDEX, CATEGORY_PROPERTY, -1);
		addStringModelProperty(SELECTED_ITEM, CATEGORY_PROPERTY);
		addStringModelProperty(TEXT, CATEGORY_PROPERTY);
		
		addStringModelProperty(DISABLED_SKIN, CATEGORY_STYLE);
		addStringModelProperty(DOWN_SKIN, CATEGORY_STYLE);
		addStringModelProperty(EDITABLE_DISABLED_SKIN, CATEGORY_STYLE);
		addStringModelProperty(EDITABLE_DOWN_SKIN, CATEGORY_STYLE);
		addStringModelProperty(EDITABLE_OVER_SKIN, CATEGORY_STYLE);
		addStringModelProperty(EDITABLE_UP_SKIN, CATEGORY_STYLE);
		addStringModelProperty(OVER_SKIN, CATEGORY_STYLE);
		addStringModelProperty(TEXT_INPUT_STYLE_NAME, CATEGORY_STYLE);
		addStringModelProperty(UP_SKIN, CATEGORY_STYLE);
	}
}

