package net.sf.amateras.air.mxml.figures;



import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class TopLabelBorder extends LinedMarginBorder {
	private Label label = new Label();

	public TopLabelBorder(Insets paddingInsets, int borderWidth, Color borderColor) {
		super(paddingInsets, borderWidth, borderColor);
	}

	@Override
	public Insets getInsets(IFigure figure) {
		label.setFont(figure.getFont());
		Insets insets = super.getInsets(figure);
		if (figure.getParent() instanceof AccordionFigure) {
			insets.top = insets.top + label.getPreferredSize().height;
		}
		return insets;
	}

	public Label getTitleLabel() {
		return label;
	}

	@Override
	public void paint(IFigure figure, Graphics graphics, Insets insets) {

		
		super.paint(figure, graphics, insets);
		try {
			
			if (figure.getParent() instanceof AccordionFigure) {
				//Gradient
				graphics.setForegroundColor(ColorConstants.white);
				graphics.setBackgroundColor(ColorConstants.button);
				Rectangle rec = figure.getBounds();
				label.setFont(figure.getFont());
				label.setForegroundColor(figure.getForegroundColor());
				//rec.height = label.getPreferredSize().height;
				graphics.fillGradient(rec, true);
				
				if (label.getForegroundColor() != null) {
					graphics.setForegroundColor(label.getForegroundColor());
				} else {
					graphics.setForegroundColor(ColorConstants.black);
				}
				//			
				int x = figure.getBounds().x;
				int y = figure.getBounds().y;
				
				label.setBounds(new Rectangle(x,y,100, 20));
				label.paint(graphics);
				//graphics.drawString(label.getText(), x + 10, y + 10);

			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
