package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ColorUtil;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

/**
 * Title Label for
 * DataGridColumn and Accordion and TabNavigater 
 * @author ogawahideko
 *
 */
public class TitleLabel extends Label {
	private static Font DEFAULT_FONT = AIRPlugin.getDefault().getFontManager().getFont("Verdana",
			10, SWT.BOLD);

	private static Font DEFAULT_FONT_WINDOWS = AIRPlugin.getDefault().getFontManager().getFont(
			"Verdana", 8, SWT.BOLD);

	private static Color DEFAULT_COLOR = AIRPlugin.getDefault().getColorManager().getColor(
			ColorUtil.toRGB("#E6E6E6"));

	private static Color DEFAULT_FORE_COLOR = AIRPlugin.getDefault().getColorManager().getColor(
			ColorUtil.toRGB("#0B333C"));

	private static Border DEFAULT_BORDER = new CompoundBorder(new LineBorder(
			ColorConstants.lightGray), new MarginBorder(3, 3, 3, 3));

	public TitleLabel() {
		setBackgroundColor(DEFAULT_COLOR);
		setForegroundColor(DEFAULT_FORE_COLOR);
		if (AIRPlugin.getDefault().getPreferenceStore().getInt(AIRPlugin.PREF_FONT_MATTING_SIZE) != 0) {
			setFont(DEFAULT_FONT_WINDOWS);
		} else {
			setFont(DEFAULT_FONT);
		}

		setMinimumSize(new Dimension(40, 15));
		setOpaque(true);
		setTextAlignment(Label.LEFT);
		setLabelAlignment(Label.LEFT);
		setBorder(DEFAULT_BORDER);
	}

}
