package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.mxml.models.TabNavigatorModel;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;

/**
 * TabNavigater figure of {@link TabNavigatorModel}
 * @author ogawahideko
 *
 */
public class TabNavigaterFigure extends AbstractFigure implements MouseListener {
	private Figure tabFigure = new Figure();
	private Figure containerFigure = new Figure();
	private int selectIndex;

	public TabNavigaterFigure() {
		setLayoutManager(new BorderLayout());

		super.add(tabFigure, BorderLayout.TOP, -1);
		ToolbarLayout layout = new ToolbarLayout(true);
		layout.setSpacing(1);
		tabFigure.setLayoutManager(new ToolbarLayout(true));
		tabFigure.setBounds(new Rectangle(0, 0, 100, 15));

		containerFigure.setLayoutManager(new StackLayout());
		containerFigure.setOpaque(true);
		containerFigure.setBorder(new LineBorder(ColorConstants.lightGray));
		super.add(containerFigure, BorderLayout.CENTER, -1);

	}

	public Label addTab(String name) {
		Label label = new TitleLabel();
		label.setText(name);
		label.setBorder(new CompoundBorder(new LineBorder(ColorConstants.lightGray),
				new MarginBorder(3, 10, 3, 10)));
		label.addMouseListener(this);
		tabFigure.add(label);
		return label;
	}

	public void removeAllTab() {
		for (int i = 0; i < tabFigure.getChildren().size(); i++) {
			((IFigure) tabFigure.getChildren().get(i)).removeMouseListener(this);
		}
		tabFigure.removeAll();
	}

	@Override
	public void add(IFigure figure, Object constraint, int index) {
		containerFigure.add(figure, constraint, index);
	}
	
	@Override
	public void remove(IFigure figure) {
		containerFigure.remove(figure);
	}

	public int getSelectIndex() {
		return selectIndex;
	}

	public void setTabFigureVisible(boolean isVisible) {
		tabFigure.setVisible(isVisible);
	}

	public void setSelectedIndex(int selectIndex) {
		this.selectIndex = selectIndex;
		for (int i = 0; i < containerFigure.getChildren().size(); i++) {
			if (selectIndex == i) {
				((IFigure) containerFigure.getChildren().get(i)).setVisible(true);
				((IFigure) tabFigure.getChildren().get(i))
						.setBackgroundColor(ColorConstants.lightGray);
			} else {
				((IFigure) containerFigure.getChildren().get(i)).setVisible(false);
				((IFigure) tabFigure.getChildren().get(i)).setBackgroundColor(ColorConstants.gray);
			}
		}

	}

	public void mouseDoubleClicked(MouseEvent me) {
		// Nothing todo.

	}

	public void mousePressed(MouseEvent me) {

		Object ms = me.getSource();
		for (int i = 0; i < tabFigure.getChildren().size(); i++) {
			if (tabFigure.getChildren().get(i) == ms) {
				setSelectedIndex(i);
				return;
			}
		}

	}

	public void mouseReleased(MouseEvent me) {
		// Nothing.todo

	}

	public int getTabPrefferedHeight() {
		return tabFigure.getPreferredSize().height;
	}

	public int getDefaultHeight() {
		return -1;
	}

	public int getDefaultWidth() {
		return -1;
	}

}
