package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class PanelFigure extends BoxFigure {
	private Color borderColor;
	private Color titleColor;
	private String title;

	private int borderWidth = 15;
	private int borderTopWidth = 30;
	private int borderBottomWidth = 15;

	private Insets padding;
	private MarginBorder paddingBorder;

	public PanelFigure() {
		padding = new Insets(0, 0, 0, 0);
		paddingBorder = new MarginBorder(padding);
		CompoundBorder border = new CompoundBorder(new MyBorder(), paddingBorder);
		setBorder(border);
		setOpaque(true);
	}

	public void setPadding(Insets insets) {
		padding.top = insets.top;
		padding.bottom = insets.bottom;
		padding.left = insets.left;
		padding.right = insets.right;

	}

	class MyBorder extends LineBorder {
		@Override
		public Insets getInsets(IFigure figure) {
			return new Insets(borderTopWidth, borderWidth, borderBottomWidth, borderWidth);
		}

		@Override
		public Color getColor() {
			return borderColor;
		}

		@Override
		public int getWidth() {
			return borderWidth;
		}

		@Override
		public void paint(IFigure figure, Graphics graphics, Insets insets) {
			super.paint(figure, graphics, insets);
			try {
				graphics.setForegroundColor(borderColor);
				int x = figure.getBounds().x;
				int y = figure.getBounds().y;
				int width = figure.getBounds().width;
				int height = figure.getBounds().height;

				graphics.setLineWidth(borderTopWidth);
				graphics.drawLine(x, y + borderTopWidth / 2, x + width, y + borderTopWidth / 2);

				graphics.setLineWidth(borderBottomWidth);
				graphics.drawLine(x, y + height - borderBottomWidth / 2, x + width, y + height
						- borderBottomWidth / 2);

				if (titleColor != null) {
					graphics.setForegroundColor(titleColor);
				}
				if (title != null) {
					graphics.drawString(title, x + borderTopWidth / 2, y + 10);
				}

			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
		repaint();
	}

	public void setBorderColor(Color color) {
		borderColor = color;
	}

	public Color getBorderColor() {
		return borderColor;
	}

	public Color getTitleColor() {
		return titleColor;
	}

	public void setTitleColor(Color color) {
		this.titleColor = color;
	}

	public int getBorderWidth() {
		return borderWidth;
	}

	public void setBorderWidth(int borderWidth) {
		this.borderWidth = borderWidth;
	}

	public int getBorderTopWidth() {
		return borderTopWidth;
	}

	public void setBorderTopWidth(int borderTopWidth) {
		this.borderTopWidth = borderTopWidth;
	}

	public int getBorderBottomWidth() {
		return borderBottomWidth;
	}

	public void setBorderBottomWidth(int borderBottomWidth) {
		this.borderBottomWidth = borderBottomWidth;
	}

}
