package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ScrollBar;

/**
 * 
 * @author Hideko Ogawa
 */
public class List extends AbstractFigure implements ColorConstants {

	private Label text;

	public List() {
		this("");
	}

	public List(String s) {
		CustomBorderLayout layout = new CustomBorderLayout();
		layout.setStretchCenterHeight(true);
		layout.setStretchCenterWidth(true);
		layout.setFillBottomAndTop(false);
		setLayoutManager(layout);
		setBackgroundColor(button);
		setOpaque(true);

		ScrollBar vbar = new ScrollBar();
		vbar.setOrientation(ScrollBar.VERTICAL);
		vbar.setMaximum(0);

		text = new Label();
		text.setText(s);
		text.setBackgroundColor(white);
		text.setOpaque(true);
		text.setLabelAlignment(Label.LEFT);
		text.setTextAlignment(Label.TOP);

		add(text, CustomBorderLayout.CENTER);
		add(vbar, CustomBorderLayout.RIGHT);

		//		setBorder(new SchemeBorder(new ButtonScheme(
		//				new Color[] { buttonDarkest, buttonDarker },
		//				new Color[] { buttonLightest, buttonDarker }
		//			)));
	}

	public void setText(String s) {
		text.setText(s);
	}

	public String getText() {
		return text.getText();
	}

	public int getDefaultWidth() {
		return 150;
	}

	public int getDefaultHeight() {
		return 140;
	}

}
