package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Color;

/**
 * 
 * @author Hideko Ogawa
 *
 */
public class DataGridColumnFigure extends AbstractFigure {
	private Label title;

	public DataGridColumnFigure() {
		setLayoutManager(new BorderLayout());
		setPreferredSize(100, 20);

		title = new TitleLabel();
		add(title, BorderLayout.CENTER);
	}

	public void setText(String text) {
		title.setText(text);
	}

	public void setWidth(int width) {
		title.setPreferredSize(width, 23);
	}

	public void setHeaderBackgroundColor(Color color) {
		if (color != null) {
			title.setBackgroundColor(color);
		}
	}

	public void setHeaderForegroundColor(Color color) {
		if (color != null) {
			title.setForegroundColor(color);
		}
	}

	public Label getTitleFigure() {
		return title;
	}

	public int getDefaultHeight() {
		return 0;
	}

	public int getDefaultWidth() {
		return 100;
	}

}
