package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;

/**
 * DataGrid Figure.
 * 
 * @author HidekoOgawa
 */
public class DataGrid extends AbstractFigure {

	public DataGrid() {
		super();
		setOpaque(true);

		setLayoutManager(new ToolbarLayout(true));
		setBorder(new LineBorder(ColorConstants.lightGray));
	}

	@SuppressWarnings("unchecked")
	public int getDefaultWidth() {
		if (getChildren().size() == 0) {
			return 300;
		} else {
			int sum = 0;
			for (IFigure f : (java.util.List<IFigure>) getChildren()) {
				sum += f.getPreferredSize().width;
			}
			return sum;
		}
	}

	public int getDefaultHeight() {
		return 120;
	}

}
