package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.draw2d.ArrowButton;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Orientable;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ButtonBorder.ButtonScheme;
import org.eclipse.swt.graphics.Color;

/**
 * ComboBox Figure
 * @author Hideko Ogawa
 */
public class ComboBox extends AbstractFigure implements ColorConstants {
	private Label label;
	private Button button;

	public ComboBox() {
		super();
		setOpaque(true);
		setLayoutManager(new BorderLayout());
		setBackgroundColor(AIRPlugin.getDefault().getColorManager().getAirColor());

		label = new Label();
		label.setBackgroundColor(ColorConstants.white);
		label.setVisible(false);
		add(label, BorderLayout.CENTER);
		label.setText("         ");

		button = new ArrowButton(Orientable.SOUTH);
		button.setBorder(null);
		button.setOpaque(false);
		button.setEnabled(false);
		button.setPreferredSize(15, 13);
		add(button, BorderLayout.RIGHT);

		setBorder(new SchemeBorder(new ButtonScheme(new Color[] { buttonLightest }, new Color[] {
				buttonDarkest, buttonDarker })));
	}

	public void setEditable(boolean isEditable) {
		label.setVisible(isEditable);
	}

	public int getDefaultWidth() {
		return 160;
	}

	public int getDefaultHeight() {
		return label.getPreferredSize().height;
	}
}
