package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.mxml.models.FlexRectangle;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Dimension;

public abstract class AbstractFigure extends Figure implements IFlexRectangleFigure {

	private FlexRectangle rectangle;

	public FlexRectangle getRectangle() {
		return rectangle;
	}

	public void setRectangle(FlexRectangle rectangle) {
		this.rectangle = rectangle;

	}

	@Override
	public Dimension getPreferredSize(int wHint, int hHint) {
		Dimension dimension = super.getPreferredSize(wHint, hHint);

		if (rectangle.getStrWidth().length() == 0 && getDefaultWidth() > 0) {
			dimension.width = getDefaultWidth();

		}
		if (rectangle.getStrHeight().length() == 0 && getDefaultHeight() > 0) {
			dimension.height = getDefaultHeight();

		}
		return dimension;
	}

}
