package net.sf.amateras.air.mxml.factory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;

import net.sf.amateras.air.ComponentImageRegistry;
import net.sf.amateras.air.mxml.models.AbstractContainerModel;
import net.sf.amateras.air.mxml.models.AbstractModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.editparts.AbstractTreeEditPart;

public class TreeEditPartFactory implements EditPartFactory {
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart part = new TreeEditPart();
		part.setModel(model);
		return part;
	}

	private class TreeEditPart extends AbstractTreeEditPart implements PropertyChangeListener {

		public void activate() {
			super.activate();
			((AbstractModel) getModel()).addPropertyChangeListener(this);
		}

		public void deactivate() {
			((AbstractModel) getModel()).removePropertyChangeListener(this);
			super.deactivate();
		}

		protected List getModelChildren() {
			if (getModel() instanceof IContainerModel) {
				//List children = new ArrayList(((IContainerModel) getModel()).getChildren());
				//Collections.reverse(children);
				return ((IContainerModel) getModel()).getChildren();
			} else {
				return Collections.EMPTY_LIST;
			}
		}

		protected void refreshVisuals() {
			AbstractModel model = (AbstractModel) getModel();
			setWidgetText(model.toString());
			setWidgetImage(ComponentImageRegistry.getImage(model));
		}


		public void propertyChange(PropertyChangeEvent evt) {
			if (evt.getPropertyName().equals(AbstractContainerModel._CHILDREN)) {
				refreshChildren();
			}
		}
	}
}
