package net.sf.amateras.air.mxml.editparts.policy;

import net.sf.amateras.air.mxml.editparts.command.AddCommand;
import net.sf.amateras.air.mxml.editparts.command.CreateCommand;
import net.sf.amateras.air.mxml.editparts.command.MoveChildCommand;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

/**
 * 
 * @author ogawahideko
 *
 */
public class ToolBarLayoutEditPolicy extends FlowLayoutEditPolicy {

	@Override
	public boolean isHorizontal() {
		IFigure figure = ((GraphicalEditPart) getHost()).getContentPane();
		LayoutManager layout = figure.getLayoutManager();
		if (layout instanceof FlowLayout)
			return ((FlowLayout) figure.getLayoutManager()).isHorizontal();
		if (layout instanceof ToolbarLayout)
			return ((ToolbarLayout) figure.getLayoutManager()).isHorizontal();
		return false;
	}

	@Override
	protected Command createAddCommand(EditPart child, EditPart after) {
		IContainerModel root = (IContainerModel) getHost().getModel();
		IComponentModel childModel = (IComponentModel) child.getModel();
		IComponentModel afterModel = after == null ? null : (IComponentModel) after.getModel();
		return new AddCommand(root, childModel, afterModel, root.getConstraint());
	}

	@Override
	protected Command createMoveChildCommand(EditPart child, EditPart after) {
		return new MoveChildCommand(getHost(), child, after);
	}

	@Override
	protected Command getCreateCommand(CreateRequest request) {
		IContainerModel root = (IContainerModel) getHost().getModel();
		return new CreateCommand(root, request, null);
	}

}
