package net.sf.amateras.air.mxml.editparts.policy;

import net.sf.amateras.air.mxml.editparts.command.DirectEditCommand;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;

/**
 * EditPolicy for Text direct edit.
 * @author ogawahideko
 *
 */
public class TextDirectEditPolicy extends DirectEditPolicy {

	private String propertyName;
	
	public TextDirectEditPolicy(String propertyName) {
		this.propertyName = propertyName;
	}
	
	@Override
	protected Command getDirectEditCommand(DirectEditRequest request) {
		DirectEditCommand command = new DirectEditCommand(propertyName);
		command.setModel(getHost().getModel());
		command.setText((String) request.getCellEditor().getValue());
		return command;
	}

	@Override
	protected void showCurrentEditValue(DirectEditRequest request) {
	}
}