package net.sf.amateras.air.mxml.editparts.command;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.mxml.models.AbstractComponentModel;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

/**
 * 
 * @author ogawahideko
 *
 */
public class OrphanChildrenCommand extends Command {

	private List<EditPart> editParts;
	private List<IContainerModel> oldParentModel;
	private List<FlexRectangle> oldRectangles;
	private List<Integer> oldChildIndex;

	public OrphanChildrenCommand(List<EditPart> editParts) {
		this.editParts = editParts;
		oldParentModel = new ArrayList<IContainerModel>();
		oldRectangles = new ArrayList<FlexRectangle>();
		oldChildIndex = new ArrayList<Integer>();
	}

	@Override
	public void execute() {
		for (EditPart editPart : editParts) {
			AbstractComponentModel model = (AbstractComponentModel) editPart.getModel();
			// backup parentModel and rectangles.
			oldParentModel.add(model.getRoot());
			oldRectangles.add(model.getConstraint().clone());
			oldChildIndex.add(model.getRoot().getChildIndex(model));
			// remove.
			model.getRoot().removeChild(model);
		}
	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public boolean canUndo() {
		return true;
	}

	@Override
	public void undo() {
		for (int i = 0; i < editParts.size(); i++) {
			EditPart editPart = editParts.get(i);
			IContainerModel model = oldParentModel.get(i);
			FlexRectangle rec = oldRectangles.get(i);

			((IComponentModel) editPart.getModel()).setConstraint(rec);
			model.addChild(oldChildIndex.get(i), ((IComponentModel) editPart.getModel()));
		}
	}
}
