package net.sf.amateras.air.mxml.editparts.command;

import net.sf.amateras.air.mxml.models.AbstractComponentModel;

import org.eclipse.gef.commands.Command;

/**
 * DirectEditCommand for text.
 * @author ogawahideko
 *
 */
public class DirectEditCommand extends Command {
	private String propertyName;
	private String oldText, newText;
	private AbstractComponentModel model;

	public DirectEditCommand(String propertyName) {
		this.propertyName = propertyName;
	}

	@Override
	public void execute() {
		//save to text string.
		oldText = model.getAttributeToString(propertyName);
		model.setAttribute(propertyName, newText);
	}

	public void setModel(Object model) {
		this.model = (AbstractComponentModel) model;
	}

	public void setText(String text) {
		newText = text;
	}

	@Override
	public void undo() {
		model.setAttribute(propertyName, oldText);
	}
}
