package net.sf.amateras.air.mxml.editparts.command;

import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.IInstallDefault;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

/**
 * CreateCommand for {@link IComponentModel}.
 * 
 * @author ogawahideko
 *
 */
public class CreateCommand extends Command {

	private IContainerModel root;
	private CreateRequest request;
	private FlexRectangle constraint;

	private IComponentModel model;

	public CreateCommand(IContainerModel root, CreateRequest request, FlexRectangle constraint) {
		this.root = root;
		this.request = request;
		this.constraint = constraint;
		model = (IComponentModel) request.getNewObject();
	}

	public CreateCommand(IContainerModel root, IComponentModel createModel, FlexRectangle constraint) {
		this.root = root;
		this.constraint = constraint;
		model = createModel;
	}

	@Override
	public void execute() {
		if (constraint == null) {
			constraint = new FlexRectangle();
			int width = 0;
			int height = 0;
			if (request != null && request.getSize() != null) {
				width = request.getSize().width;
				height = request.getSize().height;
				if (width < 100) {
					width = 100;
				}
				if (height < 10) {
					height = 10;
				}
			}

			constraint
					.setRectangle(request.getLocation().x, request.getLocation().y, width, height);
		}
		model.setConstraint(constraint);

		// default child setting.
		if (model instanceof IInstallDefault) {
			((IInstallDefault) model).installDefault();
		}
		root.addChild(model);
	}

	@Override
	public void undo() {
		root.removeChild(model);
	}

	@Override
	public boolean canExecute() {
		if (root == null) {
			return false;
		}
		return root.canChildComponent(model);
	}

}
