package net.sf.amateras.air.mxml.editparts.command;

import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;

import org.eclipse.gef.commands.Command;

/**
 * Command when location information of Component is changed.
 * 
 * @author Hideko Ogawa
 *
 */
public class ChangeConstraintCommand extends Command {

	private IComponentModel model;
	private FlexRectangle constraint;
	private FlexRectangle oldConstraint;

	public void execute() {
		model.setConstraint(this.constraint);
	}

	public void setConstraint(FlexRectangle constraint) {
		this.constraint = constraint;
	}

	public void setModel(IComponentModel model) {
		this.model = model;
		oldConstraint = model.getConstraint().clone();
	}

	@Override
	public void undo() {
		model.setConstraint(oldConstraint);
	}
}