package net.sf.amateras.air.mxml.editparts;

import java.util.List;

import net.sf.amateras.air.mxml.editparts.policy.StackLayoutEditPolicy;
import net.sf.amateras.air.mxml.figures.ViewStackFigure;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.ViewStackModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.EditPolicy;

/**
 * The editpart for the {@link ViewStackModel}.
 * @author ogawahideko
 *
 */
public class ViewStackEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		ViewStackFigure figure = new ViewStackFigure();
		updateFigure(figure, (ViewStackModel) getModel());

		return figure;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		ViewStackModel model = (ViewStackModel) getModel();
		ViewStackFigure figure = (ViewStackFigure) getFigure();
		updateFigure(figure, model);
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new StackLayoutEditPolicy());
	}

	private void updateFigure(ViewStackFigure panel, ViewStackModel model) {
		panel.setToolTip(new Label(model.toString()));
		int index = model.getSelectedIndex();
		if (index < 0) {
			index = model.getAttributeToNumber(ViewStackModel.SELECTED_INDEX);
		}
		panel.setSelectedIndex(index);
		panel.revalidate();
	}

	@Override
	protected List getModelChildren() {
		return ((IContainerModel) getModel()).getChildren();
	}

}