package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.TreeFigure;
import net.sf.amateras.air.mxml.models.TreeModel;
import net.sf.amateras.air.mxml.models.VideoDisplayModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link VideoDisplayModel}.
 * 
 * @author ogawahideko
 */
public class TreeEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		TreeFigure tree = new TreeFigure();
		tree.setOpaque(true);
		updateFigure(tree, (TreeModel) getModel());
		return tree;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((TreeFigure) getFigure(), (TreeModel) getModel());
	}

	private void updateFigure(TreeFigure figure, TreeModel model) {
		figure.setToolTip(new Label(model.toString()));
		figure.repaint();
	}

}
