package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.Text;
import net.sf.amateras.air.mxml.models.TextInputModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;

/**
 * The editpart for the {@link TextInputModel}.
 * @author ogawahideko
 *
 */
public class TextInputEditPart extends AbstractDirectEditPart {

	@Override
	protected IFigure createFigure() {
		Text text = new Text();
		text.setMinimumSize(new Dimension(50, 10));
		updateFigure(text, (TextInputModel) getModel());
		return text;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((Text) getFigure(), (TextInputModel) getModel());
	}

	private void updateFigure(Text text, TextInputModel model) {
		text.setToolTip(new Label(model.toString()));
		text.setText(model.getAttributeToString(TextInputModel.TEXT));
		AIRPlugin.getDefault().getFontManager().setFont(model, text);
		text.setForegroundColor(getColor(TextInputModel.COLOR));
		text.repaint();
	}

	@Override
	protected String getDirectEditPropertyKey() {
		return TextInputModel.TEXT;
	}

}
