package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.models.AbstractComponentModel;

import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.swt.widgets.Text;

public class TextDirectEditManager extends org.eclipse.gef.tools.DirectEditManager {
	private AbstractComponentModel model;
	private String propertyName;

	public TextDirectEditManager(GraphicalEditPart source, Class editorType,
			CellEditorLocator locator, String propertyName) {

		super(source, editorType, locator);
		model = (AbstractComponentModel) source.getModel();
		this.propertyName = propertyName;
	}

	@Override
	protected void initCellEditor() {
		getCellEditor().setValue(model.getAttribute(propertyName));
		Text text = (Text) getCellEditor().getControl();
		text.selectAll();
	}
	
	@Override
	protected void commit() {
		if (!isDirty()) {
			setDirty(true);
			showFeedback();
		}
		super.commit();
	}
	
//	@Override
//	protected boolean isDirty() {
//		//At the time of Japanese input, way it reacts, modification.
//		//Because with Japanese input ICellEditorListener does not react...
//		super.isDirty();
//		return true;
//	}
}