package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.TextArea;
import net.sf.amateras.air.mxml.models.TextAreaModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link TextAreaModel}.
 * @author ogawahideko
 *
 */
public class TextAreaEditPart extends AbstractDirectEditPart {

	@Override
	protected IFigure createFigure() {
		TextAreaModel model = (TextAreaModel) getModel();
		TextArea text = new TextArea(model.getAttributeToString(TextAreaModel.TEXT));
		updateFigure(text, model);
		return text;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		TextAreaModel model = (TextAreaModel) getModel();
		TextArea text = (TextArea) getFigure();
		updateFigure(text, model);
	}

	private void updateFigure(TextArea text, TextAreaModel model) {
		text.setToolTip(new Label(model.toString()));
		text.setText(model.getAttributeToString(TextAreaModel.TEXT));
		AIRPlugin.getDefault().getFontManager().setFont(model, text);

		text.repaint();
	}

	@Override
	protected String getDirectEditPropertyKey() {
		return TextAreaModel.TEXT;
	}

	@Override
	protected IFigure getDirectEditFigure() {
		return ((TextArea) getFigure()).getTextFigure();
	}
}
