package net.sf.amateras.air.mxml.editparts;

import java.util.List;

import net.sf.amateras.air.mxml.figures.TabNavigaterFigure;
import net.sf.amateras.air.mxml.models.AbstractContainerModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.TabNavigatorModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

/**
 * The editpart for the {@link TabNavigatorModel}.
 * @author ogawahideko
 *
 */
public class TabNavigatorEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		TabNavigatorModel model = (TabNavigatorModel) getModel();
		TabNavigaterFigure tab = new TabNavigaterFigure();
		updateFigure(tab, model);

		return tab;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		TabNavigatorModel model = (TabNavigatorModel) getModel();
		TabNavigaterFigure tab = (TabNavigaterFigure) getFigure();
		updateFigure(tab, model);

	}

	@Override
	public void refresh() {
		super.refresh();
		TabNavigatorModel model = (TabNavigatorModel) getModel();
		TabNavigaterFigure tab = (TabNavigaterFigure) getFigure();

		int index = model.getSelectedIndex();
		if (index < 0) {
			index = model.getAttributeToNumber(TabNavigatorModel.SELECTED_INDEX);;
		}
		tab.setSelectedIndex(index);
		tab.repaint();
	}

	private void updateFigure(TabNavigaterFigure tab, TabNavigatorModel model) {
		tab.setToolTip(new Label(model.toString()));
		tab.removeAllTab();

		for (int i = 0; i < getModelChildren().size(); i++) {
			IComponentModel childModel = (IComponentModel) getModelChildren().get(i);
			String name = childModel.getAttributeToString(AbstractContainerModel.LABEL);
			if (name == null) {
				name = " ";
			}
			tab.addTab(name);
		}
	}

	@Override
	protected List getModelChildren() {
		return ((TabNavigatorModel) getModel()).getChildren();
	}
	
	@Override
	protected void removeChildVisual(EditPart childEditPart) {
		try {
			IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
			getContentPane().remove(child);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("child" + childEditPart + ", this=" + this);
		}
	}

}
