package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.BoxFigure;
import net.sf.amateras.air.mxml.models.SWFLoaderModel;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;

/**
 * The editpart for the {@link SWFLoaderModel}.
 * 
 * @author ogawahideko
 */
public class SWFLoaderEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		BoxFigure box = new BoxFigure();
		box.setOpaque(true);
		box.setBorder(new LineBorder(ColorConstants.lightGray));
		updateFigure(box, (SWFLoaderModel) getModel());
		return box;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((BoxFigure) getFigure(), (SWFLoaderModel) getModel());
	}

	private void updateFigure(BoxFigure figure, SWFLoaderModel model) {
		figure.setToolTip(new Label(model.toString()));
		figure.repaint();
	}

}
