package net.sf.amateras.air.mxml.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;

import net.sf.amateras.air.mxml.editparts.policy.RootEditPolicy;
import net.sf.amateras.air.mxml.figures.RootFigure;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.RootModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;

/**
 * The editpart for the {@link RootModel}.
 * 
 * @author Naoki Takezoe
 */
public class RootEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		RootFigure figure = new RootFigure();
		return figure;
	}

	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
	}

	@Override
	protected List getModelChildren() {
		return ((IContainerModel) getModel()).getChildren();
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		refreshVisuals();
	}

	@Override
	protected void refreshVisuals() {
		//super.refreshVisuals();
		//updateFigure((RootFigure) getFigure());
		refreshChildren();
	}
}
