package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.RichTextEditorFigure;
import net.sf.amateras.air.mxml.models.RichTextEditorModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.RGB;

/**
 * The editpart for the {@link RichTextEditorModel}.
 * @author ogawahideko
 *
 */
public class RichTextEditorEditPart extends AbstractDirectEditPart {

	@Override
	protected IFigure createFigure() {
		RichTextEditorModel model = (RichTextEditorModel) getModel();
		RichTextEditorFigure text = new RichTextEditorFigure();
		updateFigure(text, model);
		return text;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		RichTextEditorModel model = (RichTextEditorModel) getModel();
		RichTextEditorFigure text = (RichTextEditorFigure) getFigure();
		updateFigure(text, model);
	}

	private void updateFigure(RichTextEditorFigure text, RichTextEditorModel model) {
		text.setToolTip(new Label(model.toString()));
		text.setText(model.getAttributeToString(RichTextEditorModel.TEXT));
		AIRPlugin.getDefault().getFontManager().setFont(model, text);
		text.setBorderColor(getColor((RGB) model.getAttribute(RichTextEditorModel.BORDER_COLOR)));
		text.setTitleColor(getColor((RGB) model.getAttribute(RichTextEditorModel.COLOR)));
		text.setTitle(model.getAttributeToString(RichTextEditorModel.TITLE));
		text.setBackgroundColor(getColor((RGB) model
				.getAttribute(RichTextEditorModel.BACKGROUND_COLOR)));

		text.repaint();
	}

	@Override
	protected String getDirectEditPropertyKey() {
		return RichTextEditorModel.TEXT;
	}

	@Override
	protected Label getDirectEditFigure() {
		return ((RichTextEditorFigure) getFigure()).getTextFigure();
	}
}
