package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.RadioButtonFigure;
import net.sf.amateras.air.mxml.models.RadioButtonModel;

import org.eclipse.draw2d.IFigure;

/**
 * The editpart for the {@link RadioButton}.
 * 
 * @author ogawahideko
 */
public class RadioButtonEditPart extends ButtonEditPart {

	@Override
	protected IFigure createFigure() {
		RadioButtonFigure button = new RadioButtonFigure();
		updateFigure(button, (RadioButtonModel) getModel());
		return button;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((RadioButtonFigure) getFigure(), (RadioButtonModel) getModel());
	}

	private void updateFigure(RadioButtonFigure button, RadioButtonModel model) {
		super.updateFigure(button, model);
	}

}
