package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.LabelFigure;
import net.sf.amateras.air.mxml.models.LabelModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link LabelModel}.
 * 
 * @author Naoki Takezoe
 */
public class LabelEditPart extends AbstractDirectEditPart {

	@Override
	protected IFigure createFigure() {
		LabelFigure label = new LabelFigure();
		label.setOpaque(true);
		label.setLabelAlignment(Label.LEFT);
		updateFigure(label, (LabelModel) getModel());
		return label;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((Label) getFigure(), (LabelModel) getModel());
	}

	private void updateFigure(Label label, LabelModel model) {
		label.setToolTip(new Label(model.toString()));
		label.setText(model.getAttributeToString(LabelModel.TEXT));
		AIRPlugin.getDefault().getFontManager().setFont(model, label);
		label.setForegroundColor(getColor(LabelModel.COLOR));

		Object align = model.getAttribute(LabelModel.TEXT_ALIGN);
		if (align != null) {
			if (align.toString().equals("right")) {
				label.setLabelAlignment(Label.RIGHT);
			} else if (align.toString().equals("center")) {
				label.setLabelAlignment(Label.CENTER);
			} else {
				label.setLabelAlignment(Label.LEFT);
			}
		}
		label.repaint();
	}

	@Override
	protected String getDirectEditPropertyKey() {
		return LabelModel.TEXT;
	}

}
